#-------------------------------------------------------------------------------
# Name:        generic functions
# Purpose:     generic function that can be used in all other modules
#
# Author:      Shimako

#-------------------------------------------------------------------------------

import os
from operator import itemgetter
import csv
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
import gc
import openpyxl



def import_dlci (dlci_data):

    currentdir = os.path.dirname(os.path.dirname(os.path.abspath("__file__")))

    # import LCI data
    # read DLCI file
    opendir = open(currentdir + "\\" + dlci_data + ".csv", "rb")
    reader = csv.reader(opendir, delimiter=',')
    raw_file = list(reader)
    # transpose file to put in alphabetical order
    transposed_file = list(map(lambda *row: [elem or '0.0' for elem in row], *raw_file))

    # first line is time, put in a vector and delete from file
    time = transposed_file[0]
    del time[2]
    del time[1]
    del time[0]
    del transposed_file[0]  # delete first line (time line)

    # sort in alphabetical order
    sorted_file = sorted(transposed_file, key=itemgetter(0))

    # create a vector for substances
    header_dlci = [["", "", ""] for x in range(len(sorted_file))]
    for i in range(0, len(sorted_file)):
        header_dlci[i][0] = sorted_file[i][0]  # substances in alphabetical order
        header_dlci[i][1] = sorted_file[i][1]
        if sorted_file[i][2] == '0.0':
            header_dlci[i][2] = ''
        else:
            header_dlci[i][2] = sorted_file[i][2]
        del sorted_file[i][2]
        del sorted_file[i][1]
        del sorted_file[i][0]
    # obtain list of lists with mass of substances
    """________________________________________________________________
    matrix of mass values
    """
    # create a matrix of zeros to avoid error in index
    matrix_dlci = [[0.0]*len(sorted_file[0]) for x in range(0, len(sorted_file))]
    # transform list with mass of substances in float
    for count in range(0, len(sorted_file)):
        for count1 in range(0, len(sorted_file[0])):
            matrix_dlci[count][count1] = float(sorted_file[count][count1])

    return header_dlci, time, matrix_dlci


def write_csv(name,data,path):
    """name means the name given to the file and assessment is which assessment
    it is for: toxicity or climate_change"""

    currentdir = os.path.dirname(os.path.dirname(os.path.abspath("__file__")))
    with open(path + name + '.csv', 'w') as fp:

        a = csv.writer(fp, delimiter=',',lineterminator = '\n')
        if any(isinstance(el, list) for el in data):
            a.writerows(data)
        else:
            a.writerow(data)

def write_excel (name,sheet, data,path):

    file_name = path+name+'.xlsx'
    exists = os.path.isfile(file_name)
    if any(isinstance(el, list) for el in data):
        if exists:
            wb = openpyxl.load_workbook(file_name)
            ws = wb.create_sheet(sheet)
            for i in range(len(data)):
                ws.append(data[i])
            wb.save(file_name)
        else:
            wb = openpyxl.Workbook()
            ws = wb.create_sheet(sheet)
            for i in range(len(data)):
                ws.append(data[i])
            std = wb.get_sheet_by_name('Sheet')
            wb.remove_sheet(std)
            wb.save(file_name)
    else:
        if exists:
            wb = openpyxl.load_workbook(file_name)
            ws = wb.create_sheet(sheet)
            for data in data:
                ws.append([data])
            wb.save(file_name)
        else:
            wb = openpyxl.Workbook()
            ws = wb.create_sheet(sheet)



            std = wb.get_sheet_by_name('Sheet')
            wb.remove_sheet(std)
            wb.save(file_name)

def reduce_data (type_reduction, how_reduction ,number_reduction, data,
                data_step = None, time_vector = None):
    """ type_reduction can be integral, average or sum
    how reduction is by number of points or times of reduction"""

    if type_reduction == 'integral':
        if how_reduction == 'number':
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    nn = number_reduction
                    ss = mm/nn
                    reduced_data.append([])
                    int_step =(time_vector[-1]-time_vector[0])/nn
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.sum(slice)*data_step/int_step)
            else:
                    mm = len(data)
                    nn = number_reduction
                    ss = mm/nn
                    int_step =(time_vector[-1]-time_vector[0])/nn
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.sum(slice)*data_step/int_step)
        elif how_reduction == 'times':
            reduced_data = []
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    ss = number_reduction
                    nn = mm/ss
                    reduced_data.append([])
                    int_step = data_step/ss
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.mean(slice)*data_step/int_step)
            else:
                    mm = len(data)
                    ss = number_reduction
                    nn = mm/ss
                    int_step = data_step/ss
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.mean(slice)*data_step/int_step)

        else:
            print('Wrong how_reduction given, data was not reduced')
            reduce_data = data
    elif type_reduction == 'average':
        if how_reduction == 'number':
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    nn = number_reduction
                    ss = mm/nn
                    reduced_data.append([])
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.mean(slice))
            else:
                    mm = len(data)
                    nn = number_reduction
                    ss = mm/nn
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.mean(slice))
        elif how_reduction == 'times':
            reduced_data = []
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    ss = number_reduction
                    nn = mm/ss
                    reduced_data.append([])
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.mean(slice))
            else:
                    mm = len(data)
                    ss = number_reduction
                    nn = mm/ss
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.mean(slice))

        else:
            print('Wrong how_reduction given, data was not reduced')
            reduce_data = data
    elif type_reduction == 'sum':
        if how_reduction == 'number':
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    nn = number_reduction
                    ss = mm/nn
                    reduced_data.append([])
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.sum(slice))
            else:
                    mm = len(data)
                    nn = number_reduction
                    ss = mm/nn
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.sum(slice))
        elif how_reduction == 'times':
            reduced_data = []
            if all(isinstance(elem, list) for elem in data):
                for ij in range(len(data)):
                    mm = len(data[ij])
                    ss = number_reduction
                    nn = mm/ss
                    reduced_data.append([])
                    for ii in range(nn):
                        slice = data[ij][ii*ss:(ii+1)*ss]
                        reduced_data[ij].append(np.sum(slice))
            else:
                    mm = len(data)
                    ss = number_reduction
                    nn = mm/ss
                    for ii in range(nn):
                        slice = data[ii*ss:(ii+1)*ss]
                        reduced_data.append(np.sum(slice))

        else:
            print('Wrong how_reduction given, data was not reduced')
            reduce_data = data
    else:
        print('Wrong type_reduction given, data was not reduced')
        reduce_data = data

    return reduced_data

def write_report (name, report, path):
    """ function in which report in txt file is written """
    with open(path + name + '.csv', 'w') as fp:

        a = csv.writer(fp, delimiter = ',', lineterminator = '\n')
        if any(isinstance(el, list) for el in report):
            a.writerows(report)
        else:
            a.writerow(report)
def human_graphic(name,
                    title1,
                    title2,
                    xdata ,
                    y1data,
                    y2data,
                    label_y1,
                    label_y2,
                    xtitle,
                    ytitle1,
                    ytitle2,
                    path,
                    font_size = 30,
                    graph_colors = None,
                    min_value_y = 0,
                    max_value_x = 100,
                    ylim = True,
                    xlim = True,
                    log_choice = True,
                    legend = "normal",
                    legend_font_size = 30,
                    size_graphic = (20.5, 16.5),
                    max_value_y1 = None,
                    max_value_y2 = None,
                    with_legend = True,
                    vector_styles = "None",
                    vector_styles_ = None
                    ):
    print(min_value_y)
    plt.style.use(['seaborn-colorblind'])

    font = {'family' : 'sans-serif',
            'weight' : 'normal',
            'size'   : font_size}
    data_length = len (y1data)
    if max_value_y1 is None:
        max_value_y1 = max(y1data)*1.2
    if max_value_y2 is None:
        max_value_y2 = max(y2data)*1.2

    mpl.rc('font', **font)

    f, (ax1, ax2) = plt.subplots(1, 2)
    ax1.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
    ax2.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
    ax1.plot(xdata, y1data,vector_styles_[0],color = graph_colors[0],label=(str(label_y1)))
    f.suptitle('Human toxicity', fontsize=30)
    ax2.plot(xdata, y2data,vector_styles_[1],color = graph_colors[1],label=(str(label_y2)))
    ax2.yaxis.tick_right()
    ax2.yaxis.set_label_position("right")
    ax1.set_xlabel(xtitle)
    ax2.set_xlabel(xtitle)
    ax1.set_ylabel(ytitle1)
    ax2.set_ylabel(ytitle2)
    ax1.set_ylim(min_value_y,max_value_y1)
    ax2.set_ylim(min_value_y,max_value_y2)
    fig = plt.gcf()
    # size of figure
    fig.set_size_inches(size_graphic)
    # save figure
    plt.savefig(path + '\\' + name + '.png', bbox_inches='tight')
    fig.clf()
    plt.close()
    gc.collect()


def create_graphics (name,
                    title,
                    xdata ,
                    ydata,
                    label_y,
                    xtitle,
                    ytitle,
                    path,
                    twinaxis = False,
                    twintitle = None,
                    ydata_twin = None,
                    label_twin = None,
                    font_size = 30,
                    graph_colors = None,
                    min_value_y = 0,
                    max_value_x = 100,
                    ylim = True,
                    xlim = True,
                    log_choice = True,
                    legend = "normal",
                    legend_font_size = 30,
                    size_graphic = (20.5, 16.5),
                    max_value_y1 = 1.0,
                    max_value_y2 = 1.0,
                    with_legend = True,
                    vector_styles = "None",
                    vector_styles_ = None
                    ):
    print(min_value_y)
    plt.style.use(['seaborn-colorblind'])

    font = {'family' : 'sans-serif',
            'weight' : 'normal',
            'size'   : font_size}
    data_length = len (ydata)

    mpl.rc('font', **font)

    if vector_styles_ is None:
        if any(isinstance(el, list) for el in ydata):
            vector_styles_ =[]
            for i in range(len(ydata)):
                data_length = len (ydata[i])
                vector_styles_.append('-')
        else:
            vector_styles_='-'
            data_length = len (ydata)
    if twinaxis:
        if any(isinstance(el, list) for el in ydata):
            f, ax1 = plt.subplots()
            ax2 = ax1.twinx()
            ax1.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            ax2.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            # Just a figure and one subplot
            for i in range(len(ydata)):
                if graph_colors:
                    ax1.plot(xdata, ydata[i] ,vector_styles_[i],marker = vector_styles[i],
                            markevery= data_length/20, color=graph_colors[i], markersize = 10, mew = 2,
                            label=(str(label_y[i])))
                else:
                    ax1.plot(xdata, ydata[i],vector_styles_[i],marker = vector_styles[i], markersize = 10, mew = 2,
                            markevery= data_length/20, label=(str(label_y[i])),dashes=(10, 10))

            for i in range(len(ydata_twin)):
                if graph_colors:
                    ax2.plot(xdata, ydata_twin [i],vector_styles_[i],marker = vector_styles[i], markersize = 10, mew = 2,
                            markevery= data_length/20, color=graph_colors[i],
                            label=(str(label_twin[i])))
                else:
                    ax2.plot(xdata, ydata_twin [i] ,vector_styles_[i],marker = vector_styles[i], markersize = 10, mew = 2,
                            markevery= data_length/20, label=(str(label_twin[i])),dashes=(10, 10))
            # setting min value for y axis
            if ylim:
                ax1.set_ylim(min_value_y,max_value_y1)
                ax2.set_ylim(min_value_y,max_value_y2*1.2)
            if xlim:
                ax1.set_xlim(None,max_value_x)
                ax2.set_xlim(None,max_value_x)

            # scale of y axis log or not
            if log_choice:
                if sum([sum(a) for a in ydata]) != 0.0:
                    ax1.set_yscale('log')
                if sum([sum(a) for a in ydata_twin]) != 0.0:
                    ax2.set_yscale('log')

            # set axis label
            ax1.set_title(title)
            ax1.set_xlabel(xtitle)
            if legend == "axis":
                ax1.set_ylabel(ytitle#, color = graph_colors[0])
                )
                ax2.set_ylabel(twintitle #, color = graph_colors[1])
                )
                print('cannot put color in axis')
            elif legend == "normal":
                ax1.set_ylabel(ytitle)
                ax2.set_ylabel(twintitle)
                h1, l1 = ax1.get_legend_handles_labels()
                h2, l2 = ax2.get_legend_handles_labels()
                ax1.legend(h1+h2, l1+l2, loc=4)
            if not with_legend:
                ax1.legend().remove()
                ax2.legend().remove()
            fig = plt.gcf()
            # size of figure
            fig.set_size_inches(size_graphic)
            # save figure
            plt.savefig(path + '\\' + name + '.png', bbox_inches='tight')
            fig.clf()
            plt.close()
            gc.collect()
        else:
            f, ax1 = plt.subplots()
            ax2 = ax1.twinx()
            ax1.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            ax2.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            # Just a figure and one subplot

            if graph_colors:
                ax1.plot(xdata, ydata,vector_styles_[0] ,marker = vector_styles , markersize = 10, mew = 2,
                        markevery= data_length/20, color=graph_colors[0],
                            label=(str(label_y)))
                ax2.plot(xdata, ydata_twin,vector_styles_[1],marker = vector_styles , markersize = 10, mew = 2,
                        markevery= data_length/20, color=graph_colors[1],
                        label=(str(label_twin)),dashes=(10, 10))
            else:
                ax1.plot(xdata, ydata ,vector_styles_[0],marker = vector_styles, markersize = 10, mew = 2,
                        markevery= data_length/20, label=(str(label_y)))
                ax2.plot(xdata, ydata ,vector_styles_[1],marker = vector_styles, markersize = 10, mew = 2,
                        markevery= data_length/20, label=(str(label_twin)),dashes=(10, 10))

            #change font size

            # setting min value for y axis
            if ylim:
                ax1.set_ylim(min_value_y,max_value_y1)
                ax2.set_ylim(min_value_y,max_value_y2)
            if xlim:
                ax1.set_xlim(None,max_value_x)
                ax2.set_xlim(None,max_value_x)

            # scale of y axis log or not
            if log_choice:
                if sum(ydata) != 0.0:
                    ax1.set_yscale('log')
                if sum(ydata_twin) != 0.0:
                    ax2.set_yscale('log')

            # set axis label
            ax1.set_title(title)
            ax1.set_xlabel(xtitle)
            if legend == "axis":
                if graph_colors:
                    ax1.set_ylabel(ytitle , color = graph_colors[0])
                    ax2.set_ylabel(twintitle , color = graph_colors[1])
                else:
                    ax1.set_ylabel(ytitle)
                    ax2.set_ylabel(twintitle)
            elif legend == "normal":
                ax1.set_ylabel(ytitle)
                ax2.set_ylabel(twintitle)
                h1, l1 = ax1.get_legend_handles_labels()
                h2, l2 = ax2.get_legend_handles_labels()
                ax1.legend(h1+h2, l1+l2, loc=4)
            if not with_legend:
                ax1.legend().remove()
                ax2.legend().remove()
            fig = plt.gcf()
            # size of figure
            fig.set_size_inches(size_graphic)
            # save figure
            plt.savefig(path + '\\' + name + '.png', bbox_inches='tight')
            fig.clf()
            plt.close()
            gc.collect()
    else:
        if any(isinstance(el, list) for el in ydata):
            f, ax = plt.subplots()
            ax.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            # Just a figure and one subplot
            for i in range(len(ydata)):
                if graph_colors:
                    ax.plot(xdata, ydata[i] ,vector_styles_[i],marker = vector_styles[i], markersize = 10, mew = 2,
                            markevery= data_length/20, color=graph_colors[i],
                                label=(str(label_y[i])))
                else:
                    ax.plot(xdata, ydata[i] ,vector_styles_[i],marker = vector_styles[i], markersize = 10, mew = 2,
                            markevery= data_length/20, label=(str(label_y[i])))

            #change font size

            # setting min value for y axis
            if ylim:
                ax.set_ylim(min_value_y,max_value_y1)
            if xlim:
                ax.set_xlim(None,max_value_x)


            # scale of y axis log or not
            if log_choice:
                if sum([sum(a) for a in ydata]) != 0.0:
                    ax.set_yscale('log')

            # set axis label
            ax.set_title(title)
            ax.set_xlabel(xtitle)
            if legend == "axis":
                ax.set_ylabel(ytitle #, color = graph_colors[0])
                )

                print('cannot put color in axis')
            elif legend == "normal":
                ax.set_ylabel(ytitle)
                plt.legend(loc=4,fontsize = legend_font_size)
            if not with_legend:
                ax.legend().remove()


            """ !!!!!!!!!!!!!!!
            """
            ax.legend(bbox_to_anchor=(1.35, 0.75))
            fig = plt.gcf()
            # size of figure
            fig.set_size_inches(size_graphic)
            # save figure
            plt.savefig(path + '\\' + name + '.png', bbox_inches='tight')
            fig.clf()
            plt.close()
            gc.collect()
        else:
            f, ax = plt.subplots()
            ax.ticklabel_format(style='sci',scilimits=(0,0),axis='y')
            # Just a figure and one subplot

            if graph_colors:
                ax.plot(xdata, ydata,vector_styles_ ,marker = vector_styles , markersize = 10, mew = 2,
                        markevery= data_length/20, color=graph_colors,
                        label=(str(label_y)))
            else:
                ax.plot(xdata, ydata,vector_styles_, marker = vector_styles , markersize = 10, mew = 2,
                        markevery= data_length/20, label=(str(label_y)))

            # setting min value for y axis
            if ylim:
                ax.set_ylim(min_value_y,max_value_y1)
            if xlim:
                ax.set_xlim(None,max_value_x)

            # scale of y axis log or not
            if log_choice:
                if sum(ydata) != 0.0:
                    ax.set_yscale('log')

            # set axis label
            ax.set_title(title)
            ax.set_xlabel(xtitle)
            if legend == "axis":
                ax.set_ylabel(ytitle , color = graph_colors)
            elif legend == "normal":
                ax.set_ylabel(ytitle)
                plt.legend(loc=4,fontsize = legend_font_size)
            if not with_legend:
                ax.legend().remove()
            fig = plt.gcf()
            # size of figure
            fig.set_size_inches(size_graphic)
            # save figure
            plt.savefig(path + '\\' + name + '.png', bbox_inches='tight')
            fig.clf()
            plt.close()
            gc.collect()




